#include <bits/stdc++.h>

// Modifikovani https://www.geeksforgeeks.org/shortest-distance-two-cells-matrix-grid/ algoritam

using namespace std;

int h, w;

class QItem {
public:
    int row;
    int col;
    int dist;
    QItem(int x, int y, int w)
        : row(x), col(y), dist(w)
    {
    }
};

int minDistance(vector<string>);

int main() {
    ios_base::sync_with_stdio(false); cin.tie(NULL);

    vector<string> grid;
    string str;

    cin >> h >> w;

    for (int i = 0; i < h; ++i) {
        cin >> str;
        grid.emplace_back(str);
    }

    cout << minDistance(grid);
}

int minDistance(vector<string> grid)
{
    QItem source(0, 0, 0);

    bool visited[h][w];
    for (int i = 0; i < h; i++) {
        for (int j = 0; j < w; j++)
        {
            if (grid[i][j] == '#')
                visited[i][j] = true;
            else
                visited[i][j] = false;
        }
    }

    source.row = source.col = 0;

    queue<QItem> q;
    q.push(source);
    visited[source.row][source.col] = true;
    while (!q.empty()) {
        QItem p = q.front();
        q.pop();

        if (p.row == h - 1 && p.col == w - 1)
            return p.dist;

        // NW
        if (p.row - 1 >= 0 && p.col - 1 >= 0 && visited[p.row - 1][p.col - 1] == false) {
            q.push(QItem(p.row - 1, p.col - 1, p.dist + 1));
            visited[p.row - 1][p.col - 1] = true;
        }

        // N
        if (p.row - 1 >= 0 && visited[p.row - 1][p.col] == false) {
            q.push(QItem(p.row - 1, p.col, p.dist + 1));
            visited[p.row - 1][p.col] = true;
        }

        // NE
        if (p.row - 1 >= 0 && p.col + 1 < w && visited[p.row - 1][p.col + 1] == false) {
            q.push(QItem(p.row - 1, p.col + 1, p.dist + 1));
            visited[p.row - 1][p.col + 1] = true;
        }

        // W
        if (p.col - 1 >= 0 && visited[p.row][p.col - 1] == false) {
            q.push(QItem(p.row, p.col - 1, p.dist + 1));
            visited[p.row][p.col - 1] = true;
        }

        // E
        if (p.col + 1 < w && visited[p.row][p.col + 1] == false) {
            q.push(QItem(p.row, p.col + 1, p.dist + 1));
            visited[p.row][p.col + 1] = true;
        }

        // SW
        if (p.row + 1 < h && p.col - 1 >= 0 && visited[p.row + 1][p.col - 1] == false) {
            q.push(QItem(p.row + 1, p.col - 1, p.dist + 1));
            visited[p.row + 1][p.col - 1] = true;
        }

        // S
        if (p.row + 1 < h && visited[p.row + 1][p.col] == false) {
            q.push(QItem(p.row + 1, p.col, p.dist + 1));
            visited[p.row + 1][p.col] = true;
        }

        //SE
        if (p.row + 1 < h && p.col + 1 < w && visited[p.row + 1][p.col + 1] == false) {
            q.push(QItem(p.row + 1, p.col + 1, p.dist + 1));
            visited[p.row + 1][p.col + 1] = true;
        }
    }
    return -1;
}